---
name: "Designer Extension Workflow"
description: How to scaffold, develop, test, and deploy a Webflow Designer Extension — a full app with UI that runs as an iframe inside the Designer.
tags: [extension, scaffold, cli, development, deployment, project-structure]
---

# Designer Extension Workflow

Designer Extensions are full apps with their own UI that run inside the Webflow Designer as iframes. They're ideal for reusable tools, complex multi-step workflows, and apps you want to distribute via the Marketplace or share with a team.

## Prerequisites

- A Webflow Workspace where you have **Admin** permissions
- Register your app in Webflow first — see [Register App](register-app.md)
- Node.js installed locally

## Quick Start

1. **Scaffold**: `npx create-webflow-extension@latest` (interactive prompts for project name, package manager, linter)
2. **Develop**: `cd <project-name> && pnpm dev` (serves at localhost:1337; also works with npm/yarn/bun)
3. **Test**: Install app on a test site via Workspace Settings > Apps & Integrations > Develop
4. **Open**: Press **"E"** in the Designer to open the Apps panel, then launch your extension
5. **Build**: `pnpm build` for deployment

## CLI Options

```bash
npx create-webflow-extension@latest [project-name] [options]

Options:
  --pm <pnpm|npm|yarn|bun>           Package manager to use (default: pnpm)
  --linter <oxlint|biome|eslint>     Linter to use (default: oxlint)
  --skip-git                         Skip git initialization
  --skip-install                     Skip dependency installation
  --quiet                            Suppress output
```

## Project Structure

Generated by `create-webflow-extension` (React 19 + TypeScript + Rspack):

```
my-extension/
├── public/
│   └── index.html        # Entry point
├── src/
│   ├── App.tsx           # Main React component
│   ├── main.tsx          # React entry point
│   └── index.css         # Styles
├── webflow.json          # Extension settings
├── rspack.config.ts      # Rspack bundler configuration
├── package.json
└── tsconfig.json
```

## Key Files

- **`webflow.json`** — Declares extension capabilities, panel size, and metadata
- **`src/App.tsx`** — Main component where you interact with the `webflow.*` Designer API
- **`src/index.css`** — Use Webflow's CSS variables from `assets/webflow-variables.css` for a native look

## Development Tips

- Use `webflow.setExtensionSize()` to set appropriate panel dimensions — see [Extension Utilities](extension-utilities.md)
- Follow [Design Guidelines](design-guidelines.md) for a UI that feels native to the Designer
- Use `webflow.notify()` to surface success and error messages to the user
- Subscribe to Designer events to keep your extension state in sync — see [Extension Utilities](extension-utilities.md)

## Deployment

- Run `pnpm build` to produce a production bundle
- See [App Submission and Listing](app-submission-and-listing.md) for Marketplace submission
- See [Marketplace Guidelines](marketplace-guidelines.md) for review criteria

## Related References

- [Create Webflow Extension Reference](create-webflow-extension-reference.md) — Full CLI docs
- [Designer APIs Reference](designer-apis-reference.md): All Webflow Designer API methods
- [Error Handling](error-handling.md): Error structure and best practices for handling API errors
- [Code Examples](code-examples.md): Cross-API examples that can be used in both the Playground and Extensions